function table=latexMFs(MFs,words)

% table=latexMFs(MFs,words)
%
% output the parameters of the MFs in LaTex table format
%
% Dongrui WU (dongruiw@usc.edu), 5/5/2008

N=size(words,1);
for i=1:N %% name
    for j=1:9
        MFs(i,j)=round(MFs(i,j)*100)/100;
    end

    table(i,1:min(size(words,2),25))=words(i,1:min(size(words,2),25));
    table(i,26:27)=' [';
    for j=1:4
        temp1='      ';
        temp2=num2str(MFs(i,j));
        if length(temp2)==1 & MFs(i,j)~=1 & MFs(i,j)~=0
            temp2=[temp2 '.00'];
        end
        if length(temp2)==3
            temp2=[temp2 '0'];
        end
        if j<4
            temp1(1:length(temp2)+2)=[temp2 ', '];
        else
            temp1(7-length(temp2):6)=temp2;
        end
        table(i,(22+j*6):(27+j*6))=temp1;
    end
    table(i,52:54)='] [';
    for j=1:5
        temp1='      ';
        temp2=num2str(MFs(i,4+j));
        if length(temp2)==1 & MFs(i,4+j)~=0 & MFs(i,4+j)~=1
            temp2=[temp2 '.00'];
        end
        if length(temp2)==3
            temp2=[temp2 '0'];
        end
        if j<5
            temp1(1:length(temp2)+2)=[temp2 ', '];
        else
            temp1(7-length(temp2):6)=temp2;
        end
        table(i,(49+j*6):(54+j*6))=temp1;
    end
    [C, Cl, Cr]=centroidIT2(MFs(i,:));
    tempCl='0.00';
    tempCr='0.00';
    tempC='0.00';
    tempCl(1:length(num2str(round(Cl*100)/100)))=num2str(round(Cl*100)/100);
    tempCr(1:length(num2str(round(Cr*100)/100)))=num2str(round(Cr*100)/100);
    tempC(1:length(num2str(round(C*100)/100)))=num2str(round(C*100)/100);
    table(i,85:104)=['] [' tempCl ',' tempCr '] ' tempC '  '];
end
